<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Helper;

/**
 * Class Factory
 * @package Sso\RestBundle\Api\Helper
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return String\Index
     */
    public function string()
    {
        if (!isset($this->facSetter['string'])) {
            $this->facSetter['string'] = new String\Index();
        }
        return $this->facSetter['string'];
    }

    /**
     * @return Mapper\Index
     */
    public function mapper()
    {
        if (!isset($this->facSetter['mapper'])) {
            $this->facSetter['mapper'] = new Mapper\Index();
        }
        return $this->facSetter['mapper'];
    }
}
