<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Validate;

use Sso\RestBundle\Api\Manager as ApiManager;

/**
 * Class Factory
 * @package Sso\RestBundle\Api\Validate
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Factory constructor.
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return Credentials\Index
     */
    public function credentials()
    {
        if (!isset($this->facSetter['credentials'])) {
            $this->facSetter['credentials'] = new Credentials\Index($this->apiM);
        }
        return $this->facSetter['credentials'];
    }
}
