<?php

/**
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Model\Request\User\PostApplicationAttributes;

use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 * @package Sso\RestBundle\Model\Request\User\PostApplicationAttributes
 * @Serializer\XmlRoot("userApplicationAttributes")
 */
class Request
{
    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 2,
     *      max = 255
     * )
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("applications")
     * @Serializer\Type("array<Sso\RestBundle\Model\Request\User\PostApplicationAttributes\ApplicationType>")
     * @Serializer\XmlList(inline = false, entry = "application")
     *
     * @var array
     */
    private $applications;

    /**
     * Request constructor.
     */
    public function __construct()
    {
        $this->applications = array();
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @return ApplicationType[]
     */
    public function getApplications()
    {
        return $this->applications;
    }
}
