<?php

/**
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Model\Response\Idp\PostLogin;

use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;

/**
 * Class Response
 * @package Sso\RestBundle\Model\Response\Idp\PostLogin
 *
 * @Serializer\XmlRoot("response")
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $status;

    /**
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("durationSeconds")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $durationSeconds;

    /**
     * @Serializer\SerializedName("loginStatus")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $loginStatus;

    /**
     * @Serializer\SerializedName("userIdentifier")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userIdentifier;

    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("userGuid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userGuid;

    /**
     * @Serializer\SerializedName("userAuthId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userAuthId;

    /**
     * @Serializer\SerializedName("userLdapSearchAttributes")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userLdapSearchAttributes;

    /**
     * @Serializer\SerializedName("userLdapSearchValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userLdapSearchValue;

    /**
     * @Serializer\SerializedName("userEmail")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userEmail;

    /**
     * @Serializer\SerializedName("userFirstname")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userFirstname;

    /**
     * @Serializer\SerializedName("userLastname")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userLastname;

    /**
     * @Serializer\SerializedName("mfaEnabled")
     * @Serializer\Type("boolean")
     *
     * @var boolean
     */
    private $mfaEnabled = false;

    /**
     * @Serializer\SerializedName("mfaQrCode")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $mfaQrCode;

    /**
     * @Serializer\SerializedName("forcePasswordReset")
     * @Serializer\Type("boolean")
     *
     * @var boolean
     */
    private $forcePasswordReset = false;

    /**
     * @Serializer\SerializedName("resetPasswordToken")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $resetPasswordToken;

    /**
     * @Serializer\SerializedName("resetPasswordTokenExpire")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $resetPasswordTokenExpire;

    /**
     * @Serializer\SerializedName("lastLogin")
     * @Serializer\Type("DateTime")
     *
     * @var string
     */
    private $lastLogin;

    /**
     * @Serializer\SerializedName("loginFails")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $loginFails;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->trackId = ApiException::getTrackId();
    }

    /**
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param int $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return Response
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @param string $trackId
     * @return Response
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;

        return $this;
    }

    /**
     * @return string
     */
    public function getLastLogin()
    {
        return $this->lastLogin;
    }

    /**
     * @param string $lastLogin
     * @return Response
     */
    public function setLastLogin($lastLogin)
    {
        $this->lastLogin = $lastLogin;

        return $this;
    }

    /**
     * @return int
     */
    public function getLoginFails()
    {
        return $this->loginFails;
    }

    /**
     * @param int $loginFails
     * @return Response
     */
    public function setLoginFails($loginFails)
    {
        $this->loginFails = $loginFails;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }

    /**
     * @param string $userIdentifier
     * @return Response
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = $userIdentifier;

        return $this;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return Response
     */
    public function setUsername($username)
    {
        $this->username = $username;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserGuid()
    {
        return $this->userGuid;
    }

    /**
     * @param string $userGuid
     * @return Response
     */
    public function setUserGuid($userGuid)
    {
        $this->userGuid = $userGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserEmail()
    {
        return $this->userEmail;
    }

    /**
     * @param string $userEmail
     * @return Response
     */
    public function setUserEmail($userEmail)
    {
        $this->userEmail = $userEmail;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserFirstname()
    {
        return $this->userFirstname;
    }

    /**
     * @param string $userFirstname
     * @return Response
     */
    public function setUserFirstname($userFirstname)
    {
        $this->userFirstname = $userFirstname;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserLastname()
    {
        return $this->userLastname;
    }

    /**
     * @param string $userLastname
     * @return Response
     */
    public function setUserLastname($userLastname)
    {
        $this->userLastname = $userLastname;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getLoginStatus()
    {
        return $this->loginStatus;
    }

    /**
     * @param mixed $loginStatus
     * @return Response
     */
    public function setLoginStatus($loginStatus)
    {
        $this->loginStatus = $loginStatus;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserAuthId()
    {
        return $this->userAuthId;
    }

    /**
     * @param string $userAuthId
     * @return Response
     */
    public function setUserAuthId($userAuthId)
    {
        $this->userAuthId = $userAuthId;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserLdapSearchAttributes()
    {
        return $this->userLdapSearchAttributes;
    }

    /**
     * @param string $userLdapSearchAttributes
     * @return Response
     */
    public function setUserLdapSearchAttributes($userLdapSearchAttributes)
    {
        $this->userLdapSearchAttributes = $userLdapSearchAttributes;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserLdapSearchValue()
    {
        return $this->userLdapSearchValue;
    }

    /**
     * @param string $userLdapSearchValue
     * @return Response
     */
    public function setUserLdapSearchValue($userLdapSearchValue)
    {
        $this->userLdapSearchValue = $userLdapSearchValue;

        return $this;
    }

    /**
     * @return string
     */
    public function getDurationSeconds()
    {
        return $this->durationSeconds;
    }

    /**
     * @param string $durationSeconds
     * @return Response
     */
    public function setDurationSeconds($durationSeconds)
    {
        $this->durationSeconds = round($durationSeconds, 4);

        return $this;
    }

    /**
     * @return boolean
     */
    public function isMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param boolean $mfaEnabled
     * @return Response
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = (boolean)$mfaEnabled;

        return $this;
    }

    /**
     * @param string $mfaQrCode
     * @return Response
     */
    public function setMfaQrCode($mfaQrCode)
    {
        $this->mfaQrCode = $mfaQrCode;
        return $this;
    }

    /**
     * @return bool
     */
    public function isForcePasswordReset()
    {
        return $this->forcePasswordReset;
    }

    /**
     * @param bool $forcePasswordReset
     * @return Response
     */
    public function setForcePasswordReset($forcePasswordReset)
    {
        $this->forcePasswordReset = $forcePasswordReset;
        return $this;
    }

    /**
     * @return string
     */
    public function getResetPasswordToken()
    {
        return $this->resetPasswordToken;
    }

    /**
     * @param string $resetPasswordToken
     * @return Response
     */
    public function setResetPasswordToken($resetPasswordToken)
    {
        $this->resetPasswordToken = $resetPasswordToken;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getResetPasswordTokenExpire()
    {
        return $this->resetPasswordTokenExpire;
    }

    /**
     * @param \DateTime $resetPasswordTokenExpire
     * @return Response
     */
    public function setResetPasswordTokenExpire($resetPasswordTokenExpire)
    {
        $this->resetPasswordTokenExpire = $resetPasswordTokenExpire;
        return $this;
    }
}
