<?php

/**
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Model\Response\Mfa\PostMfaAddUser;

use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;

/**
 * Class Response
 * @package Sso\RestBundle\Model\Response\Idp\PostLogin
 *
 * @Serializer\XmlRoot("response")
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $status;

    /**
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("durationSeconds")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $durationSeconds;

    /**
     * @Serializer\SerializedName("userEmail")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userEmail;

    /**
     * @Serializer\SerializedName("userFirstname")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userFirstname;

    /**
     * @Serializer\SerializedName("userLastname")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userLastname;

    /**
     * @Serializer\SerializedName("mfaEnabled")
     * @Serializer\Type("boolean")
     *
     * @var boolean
     */
    private $mfaEnabled = false;

    /**
     * @Serializer\SerializedName("qrCode")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $qrCode;

    /**
     * @Serializer\SerializedName("lastLogin")
     * @Serializer\Type("DateTime")
     *
     * @var string
     */
    private $lastLogin;

    /**
     * @Serializer\SerializedName("loginFails")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $loginFails;


    public function __construct()
    {
        $this->trackId = ApiException::getTrackId();
    }

    /**
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param int $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return Response
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @param string $trackId
     * @return Response
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;

        return $this;
    }

    /**
     * @return string
     */
    public function getDurationSeconds()
    {
        return $this->durationSeconds;
    }

    /**
     * @param string $durationSeconds
     * @return Response
     */
    public function setDurationSeconds($durationSeconds)
    {
        $this->durationSeconds = $durationSeconds;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserEmail()
    {
        return $this->userEmail;
    }

    /**
     * @param string $userEmail
     * @return Response
     */
    public function setUserEmail($userEmail)
    {
        $this->userEmail = $userEmail;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserFirstname()
    {
        return $this->userFirstname;
    }

    /**
     * @param string $userFirstname
     * @return Response
     */
    public function setUserFirstname($userFirstname)
    {
        $this->userFirstname = $userFirstname;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserLastname()
    {
        return $this->userLastname;
    }

    /**
     * @param string $userLastname
     * @return Response
     */
    public function setUserLastname($userLastname)
    {
        $this->userLastname = $userLastname;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param boolean $mfaEnabled
     * @return Response
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = $mfaEnabled;

        return $this;
    }

    /**
     * @return string
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * @param string $qrCode
     * @return Response
     */
    public function setQrCode($qrCode)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * @return string
     */
    public function getLastLogin()
    {
        return $this->lastLogin;
    }

    /**
     * @param string $lastLogin
     * @return Response
     */
    public function setLastLogin($lastLogin)
    {
        $this->lastLogin = $lastLogin;

        return $this;
    }

    /**
     * @return int
     */
    public function getLoginFails()
    {
        return $this->loginFails;
    }

    /**
     * @param int $loginFails
     * @return Response
     */
    public function setLoginFails($loginFails)
    {
        $this->loginFails = $loginFails;

        return $this;
    }
}
