<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\RestBundle\Model\Response\User\PostShow;

use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;

/**
 * Class Response
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\RestBundle\Model\Response\User\PostShow
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $status;

    /**
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("durationSeconds")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $durationSeconds;

    /**
     * @Serializer\SerializedName("userIdentifier")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userIdentifier;

    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("userGuid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $userGuid;

    /**
     * @Serializer\SerializedName("active")
     * @Serializer\Type("boolean")
     *
     * @var boolean
     */
    private $active;

    /**
     * @Serializer\SerializedName("userAuthId")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userAuthId;

    /**
     * @Serializer\SerializedName("userLdapSearchAttributes")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userLdapSearchAttributes;

    /**
     * @Serializer\SerializedName("userLdapSearchValue")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userLdapSearchValue;

    /**
     * @Serializer\SerializedName("userEmail")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userEmail;

    /**
     * @Serializer\SerializedName("userFirstname")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userFirstname;

    /**
     * @Serializer\SerializedName("userLastname")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userLastname;

    /**
     * @Serializer\SerializedName("mfaEnabled")
     * @Serializer\Type("boolean")
     *
     * @var boolean
     */
    private $mfaEnabled = false;

    /**
     * @Serializer\SerializedName("mfaQrCode")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $mfaQrCode;

    /**
     * @Serializer\SerializedName("forcePasswordReset")
     * @Serializer\Type("boolean")
     *
     * @var boolean
     */
    private $forcePasswordReset = false;

    /**
     * @Serializer\SerializedName("resetPasswordToken")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $resetPasswordToken;

    /**
     * @Serializer\SerializedName("resetPasswordTokenExpire")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime|null
     */
    private $resetPasswordTokenExpire;

    /**
     * @Serializer\SerializedName("lastLogin")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime|null
     */
    private $lastLogin;

    /**
     * @Serializer\SerializedName("loginFails")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $loginFails;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->trackId = ApiException::getTrackId();
    }

    /**
     * @param int $status
     */
    public function setStatus(int $status): void
    {
        $this->status = $status;
    }

    /**
     * @param string $message
     */
    public function setMessage(string $message): void
    {
        $this->message = $message;
    }

    /**
     * @param string $trackId
     */
    public function setTrackId(string $trackId): void
    {
        $this->trackId = $trackId;
    }

    /**
     * @param string $durationSeconds
     */
    public function setDurationSeconds(string $durationSeconds): void
    {
        $this->durationSeconds = $durationSeconds;
    }

    /**
     * @param string $userIdentifier
     */
    public function setUserIdentifier(string $userIdentifier): void
    {
        $this->userIdentifier = $userIdentifier;
    }

    /**
     * @param string $username
     */
    public function setUsername(string $username): void
    {
        $this->username = $username;
    }

    /**
     * @param string $userGuid
     */
    public function setUserGuid(string $userGuid): void
    {
        $this->userGuid = $userGuid;
    }

    /**
     * @param bool $active
     */
    public function setActive(bool $active): void
    {
        $this->active = $active;
    }

    /**
     * @param string|null $userAuthId
     */
    public function setUserAuthId(?string $userAuthId): void
    {
        $this->userAuthId = $userAuthId;
    }

    /**
     * @param string|null $userLdapSearchAttributes
     */
    public function setUserLdapSearchAttributes(?string $userLdapSearchAttributes): void
    {
        $this->userLdapSearchAttributes = $userLdapSearchAttributes;
    }

    /**
     * @param string|null $userLdapSearchValue
     */
    public function setUserLdapSearchValue(?string $userLdapSearchValue): void
    {
        $this->userLdapSearchValue = $userLdapSearchValue;
    }

    /**
     * @param string|null $userEmail
     */
    public function setUserEmail(?string $userEmail): void
    {
        $this->userEmail = $userEmail;
    }

    /**
     * @param string|null $userFirstname
     */
    public function setUserFirstname(?string $userFirstname): void
    {
        $this->userFirstname = $userFirstname;
    }

    /**
     * @param string|null $userLastname
     */
    public function setUserLastname(?string $userLastname): void
    {
        $this->userLastname = $userLastname;
    }

    /**
     * @param bool $mfaEnabled
     */
    public function setMfaEnabled(bool $mfaEnabled): void
    {
        $this->mfaEnabled = $mfaEnabled;
    }

    /**
     * @param string|null $mfaQrCode
     */
    public function setMfaQrCode(?string $mfaQrCode): void
    {
        $this->mfaQrCode = $mfaQrCode;
    }

    /**
     * @param bool $forcePasswordReset
     */
    public function setForcePasswordReset(bool $forcePasswordReset): void
    {
        $this->forcePasswordReset = $forcePasswordReset;
    }

    /**
     * @param string|null $resetPasswordToken
     */
    public function setResetPasswordToken(?string $resetPasswordToken): void
    {
        $this->resetPasswordToken = $resetPasswordToken;
    }

    /**
     * @param \DateTime|null $resetPasswordTokenExpire
     */
    public function setResetPasswordTokenExpire(?\DateTime $resetPasswordTokenExpire): void
    {
        $this->resetPasswordTokenExpire = $resetPasswordTokenExpire;
    }

    /**
     * @param \DateTime|null $lastLogin
     */
    public function setLastLogin(?\DateTime $lastLogin): void
    {
        $this->lastLogin = $lastLogin;
    }

    /**
     * @param int $loginFails
     */
    public function setLoginFails(int $loginFails): void
    {
        $this->loginFails = $loginFails;
    }
}
