<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2018 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace  Sso\RestBundle\Tests\Model\Request\Idp;

use PHPUnit\Framework\TestCase;
use Sso\RestBundle\Model\Request\Idp\Factory;
use Sso\RestBundle\Model\Request\Idp;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\Model\Request\Idp
 */
class FactoryTest extends TestCase
{
    /**
     * @return void
     */
    public function testFactory()
    {
        $factory = new Factory();
        $this->assertInstanceOf(Idp\PostLogin\Request::class, $factory->postLogin());
        $this->assertInstanceOf(Idp\PostLoginSuccess\Request::class, $factory->postLoginSuccess());
        $this->assertInstanceOf(Idp\PostLoginFailed\Request::class, $factory->postLoginFailed());
    }
}
