<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2018 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace  Sso\RestBundle\Tests\Model\Response\Idp\PostLoginSuccess;

use PHPUnit\Framework\TestCase;
use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Sso\RestBundle\Model\Response\Idp\PostLoginSuccess\Response as ResponseModel;

/**
 * Class ResponseTest
 * @package Sso\RestBundle\Tests\Model\Response\Idp\PostLoginSuccess
 */
class ResponseTest extends TestCase
{
    /**
     * @return void
     */
    public function testResponseModelSerializer()
    {
        /** @var Serializer $serializer */
        $serializer = SerializerBuilder::create()->build();

        $responseModel = new ResponseModel();
        $responseModel->setStatus(200);
        $responseModel->setMessage('OK');
        $responseModel->setTrackId('bfdff27708');
        $responseModel->setDurationSeconds('0.4736');
        $responseModel->setUserIdentifier('admin');
        $responseModel->setUsername('admin');
        $responseModel->setUserFirstname('7753aed5');
        $responseModel->setUserLastname('eb521d95');
        $responseModel->setMfaEnabled(true);
        $responseModel->setLastLogin(new \DateTime('2016-01-04T12:35:48+0100'));
        $responseModel->setLoginFails(2);

        $responseJson = $serializer->serialize($responseModel, 'json');
        $expectedJson = '{
                          "status": 200,
                          "message": "OK",
                          "trackId": "bfdff27708",
                          "durationSeconds": "0.4736",
                          "userIdentifier": "admin",
                          "username": "admin",
                          "userFirstname": "7753aed5",
                          "userLastname": "eb521d95",
                          "mfaEnabled": true,
                          "lastLogin": "2016-01-04T12:35:48+0100",
                          "loginFails": 2
                        }';

        $this->assertJsonStringEqualsJsonString($expectedJson, $responseJson);
    }

    /**
     * @return void
     */
    public function testResponseModelGetter()
    {
        $responseModel = new ResponseModel();
        $responseModel->setStatus(200);
        $responseModel->setMessage('OK');
        $responseModel->setTrackId('bfdff27708');
        $responseModel->setDurationSeconds('0.4736');
        $responseModel->setUserIdentifier('admin');
        $responseModel->setUsername('admin');
        $responseModel->setUserFirstname('7753aed5');
        $responseModel->setUserLastname('eb521d95');
        $responseModel->setUserEmail('eb521d95');
        $responseModel->setMfaEnabled(true);
        $responseModel->setLastLogin(new \DateTime('2018-01-04T13:35:48+0100'));
        $responseModel->setLoginFails(2);

        $this->assertEquals(200, $responseModel->getStatus());
        $this->assertEquals('OK', $responseModel->getMessage());
        $this->assertEquals('bfdff27708', $responseModel->getTrackId());
        $this->assertEquals('0.4736', $responseModel->getDurationSeconds());
        $this->assertEquals('admin', $responseModel->getUserIdentifier());
        $this->assertEquals('admin', $responseModel->getUsername());
        $this->assertEquals('7753aed5', $responseModel->getUserFirstname());
        $this->assertEquals('eb521d95', $responseModel->getUserLastname());
        $this->assertEquals('eb521d95', $responseModel->getUserEmail());
        $this->assertEquals(true, $responseModel->isMfaEnabled());
        $this->assertEquals(new \DateTime('2018-01-04T13:35:48+0100'), $responseModel->getLastLogin());
        $this->assertEquals(2, $responseModel->getLoginFails());
    }
}
