<?php

/**
 *
 * @class Factory
 * @author buchhofer
 *
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\RestBundle\Worker\Token;

use Sso\RestBundle\Api\Manager as RestApiManager;

/**
 * Class Factory
 * @package Sso\RestBundle\Worker\Token
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var RestApiManager
     */
    protected $restApiM;

    /**
     * @param RestApiManager $restApiM
     */
    public function __construct(RestApiManager $restApiM)
    {
        $this->restApiM = $restApiM;
    }

    /**
     * @return PostToken\Handler
     */
    public function postToken()
    {
        if (!isset($this->facSetter['postToken'])) {
            $this->facSetter['postToken'] = new PostToken\Handler($this->restApiM);
        }

        return $this->facSetter['postToken'];
    }
}
