<?php

/**
 *
 * @class Factory
 * @author buchhofer
 *
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\RestBundle\Worker\User;

use Sso\RestBundle\Api\Manager as RestApiManager;

/**
 * Class Factory
 * @package Sso\RestBundle\Worker\User
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var RestApiManager
     */
    protected $restApiM;

    /**
     * @param RestApiManager $restApiM
     */
    public function __construct(RestApiManager $restApiM)
    {
        $this->restApiM = $restApiM;
    }

    /**
     * @return ApplicationAttributes\Handler
     */
    public function postApplicationAttributes()
    {
        if (!isset($this->facSetter['applicationAttributes'])) {
            $this->facSetter['applicationAttributes'] = new ApplicationAttributes\Handler($this->restApiM,
                $this->restApiM->webserviceDatabase()->webservice());
        }

        return $this->facSetter['applicationAttributes'];
    }

    /**
     * @return Show\Handler
     */
    public function postShow()
    {
        if (!isset($this->facSetter['show'])) {
            $this->facSetter['show'] = new Show\Handler($this->restApiM, $this->restApiM->webserviceDatabase()->webservice());
        }

        return $this->facSetter['show'];
    }
}
