<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model\Request\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps ServiceProvider
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class ServiceProvider
{

    /**
     * @Serializer\SerializedName("ServiceToken")
     * @var string
     */
    private $ServiceToken;

    /**
     * @Serializer\SerializedName("ServiceName")
     * @var string
     */
    private $ServiceName;

    /**
     *
     * @param string $ServiceToken
     * @return ServiceProvider
     */
    public function setServiceToken($ServiceToken)
    {
        $this->ServiceToken = (string)$ServiceToken;

        return $this;
    }

    /**
     *
     * @return string
     */
    public function getServiceToken()
    {
        return $this->ServiceToken;
    }

    /**
     * @param string $ServiceName
     * @return ServiceProvider
     */
    public function setServiceName($ServiceName)
    {
        $this->ServiceName = (string)$ServiceName;

        return $this;
    }

    /**
     *
     * @return string
     */
    public function getServiceName()
    {
        return $this->ServiceName;
    }
}
