<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierTestBundle\Api;

use Sso\Tools\UserIdentifierBundle\Api\ControllerInterface;
use Sso\Tools\UserIdentifierTestBundle\Exception\RuntimeException;

/**
 * Class Controller
 *
 * This class is used for testing only
 * It prevents using the external service
 * to get and validate a userIdentifier
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\Tools\UserIdentifierTestBundle\Api
 */
class Controller implements ControllerInterface
{
    /**
     * @var string
     */
    private $environment;


    /**
     * Controller constructor.
     * @param string $environment
     */
    public function __construct($environment)
    {
        $this->environment = $environment;
    }

    /**
     * @param string $username
     * @param string $password
     * @return bool|string UserIdentifier on success, false otherwise
     */
    public function userIdentifierGet($username, $password)
    {
        if ('test' !== $this->environment) {
            throw new RuntimeException('This method is only allowed in test environment!');
        }
        return hash('sha512', mt_rand() . '#' . microtime());
    }

    /**
     * @param string $username
     * @param string $userIdentifier
     * @return boolean
     */
    public function userIdentifierValidate($username, $userIdentifier)
    {
        if ('test' !== $this->environment) {
            throw new RuntimeException('This method is only allowed in test environment!');
        }
        return 128 === strlen($userIdentifier);
    }
}
