<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */


namespace Sso\WebserviceBundle\Api;

/**
 * Interface AuthorizationManagerInterface
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Api
 */
interface AuthorizationManagerInterface
{
    /**
     * @param string $applicationName
     * @return bool
     */
    public function canReadApplication(string $applicationName): bool;

    /**
     * @return array
     */
    public function getUserRolesApplicationRead(): array;

    /**
     * @param string $applicationName
     * @return bool
     */
    public function canWriteApplication(string $applicationName): bool;

    /**
     * @return array
     */
    public function getUserRolesApplicationWrite(): array;
}
