<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Api\Configuration;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class IndexConfiguration
 * @package Sso\WebserviceBundle\Api\Configuration
 */
class IndexConfiguration
{
    /**
     * @var Container
     */
    public $container;

    /**
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * @param string $confParam
     * @return string
     */
    public function getParam($confParam)
    {
        return $this->container->getParameter($confParam);
    }
}
