<?php

/**
 * Error storage
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Api\Error;

use Sso\WebserviceBundle\Api\Error\Type;

/**
 * Class Storage
 * @package Sso\WebserviceBundle\Api\Error
 */
class Storage
{

    /**
     * List of errors
     *
     * @var Type\Base[]
     */
    protected $_errors = array();

    /**
     * Add error
     * @param Type\Base $error
     */
    public function addError(Type\Base $error)
    {
        $key = $error->getIdentifier();
        if (isset($this->_errors[$key])) {
            $this->_errors[$key]->incErrorCount($error->getErrorCount());
        } else {
            $this->_errors[$key] = $error;
        }
    }

    /**
     * List of errors
     *
     * @return Type\Base[]
     */
    public function getErrors()
    {
        return array_values($this->_errors);
    }

    /**
     * Has errors
     *
     * @return bool
     */
    public function hasErrors()
    {
        return 0 < count($this->getErrors());
    }

    /**
     * Copy errors from another error storage
     *
     * @param Type\Base[] $errors
     */
    public function addErrors($errors)
    {
        foreach ($errors as $error) {
            $this->addError($error);
        }
    }
}
