<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Api\IdentityProvider;

/**
 * Class Validator
 * @package Sso\WebserviceBundle\Api\IdentityProvider
 */
class Validator
{

    /**
     * sha512 hash length
     * 
     * @var int
     */
    protected $_hashLength = 128;

    /**
     * Validate lenght and characters of user-identifier
     * 
     * @param string $userIdentifier
     * @return bool True on success, false otherwise
     */
    public function validateHash($userIdentifier)
    {
        return preg_match('/^[a-f0-9]{' . $this->_hashLength . '}$/', $userIdentifier);
    }

    /**
     * @param string $username
     * @return bool
     */
    public function validateUsername($username)
    {
        return is_string($username) && 0 < strlen($username);
    }
}
