<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Api\Logger;

use Psr\Log\LoggerInterface;

/**
 * Class Index
 * @package Sso\WebserviceBundle\Api\Logger
 */
class Index
{
    /**
     * @var LoggerInterface
     */
    protected $_log;

    /**
     * @var LoggerInterface
     */
    protected $logDeprecated;

    /**
     * @var string
     */
    protected $_trackId;

    /**
     * Constructor
     * 
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function __construct(LoggerInterface $logger, LoggerInterface $logDeprecated = null)
    {
        $this->_trackId = substr(md5(uniqid(rand(), true)), 0, 10);
        $this->_log = $logger;
        $this->logDeprecated = null !== $logDeprecated ? $logDeprecated : $logger;
    }

    /**
     * @return string
     */
    public function trackId()
    {
        return $this->_trackId;
    }

    /**
     * @param string $message
     */
    public function debug($message)
    {
        $this->_log->debug($message);
    }

    /**
     * Log info message
     * 
     * @param string $message
     */
    public function info($message)
    {
        $this->_log->info($message);
    }

    /**
     * Log error message
     * 
     * @param string $message
     */
    public function error($message)
    {
        $this->_log->error($message);
    }

    /**
     * Log critical error message
     * 
     * @param string|\Exception $message
     */
    public function crit($message)
    {
        $this->_log->critical($message);
    }

    /**
     * Log message
     * 
     * @param string|\Exception $message
     * @param int $priority
     */
    public function log($message, $priority)
    {
        $this->_log->log($priority, $message);
    }

    /**
     * Log deprecated messages into separate logger channel
     *
     * @param $message
     */
    public function deprecated($message)
    {
        $this->logDeprecated->error($message);
    }
}
