<?php

/**
 * User: sb
 * Date: 07.04.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\WebserviceBundle\Api;

use Sso\WebserviceBundle\Api\PasswordPolicy\History\Service as HistoryService;
use Sso\WebserviceBundle\ErrorHandler\ErrorHandler;
use JMS\Serializer\SerializerInterface;
use LifeStyle\Tools\MfaBundle\MfaCreator;
use Sso\WebserviceBundle\PasswordCrypt\PasswordCryptRepositoryInterface;
use Sso\WebserviceBundle\Security\Authorisation\UserAuthorization;
use Symfony\Component\HttpKernel\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Api manager
 */
class Manager implements ApiManagerInterface
{

    /**
     * @var LoggerInterface
     */
    public $logger;

    /**
     * @var \Symfony\Component\DependencyInjection\ContainerInterface
     */
    public $container;

    /**
     * @var \Sso\WebserviceBundle\Database\Manager
     */
    protected $_databaseManager;

    /**
     * Manager constructor.
     * @param Container $container
     * @param LoggerInterface $logger
     */
    public function __construct(Container $container, LoggerInterface $logger)
    {
        $this->logger = $logger;
        $this->container = $container;
    }

    /**
     * @var array
     */
    protected $api;

    /**
     * @return Logger\Index
     */
    public function logger()
    {

        if (!isset($this->api[__FUNCTION__])) {
            // Logger for deprecated warning messages
            $logDeprecated = $this->container->has('monolog.logger.dep') ? $this->container->get('monolog.logger.dep') : null;
            $this->api[__FUNCTION__] = new Logger\Index($this->logger, $logDeprecated);
        }

        return $this->api[__FUNCTION__];
    }

    /**
     * @return Mail\IndexMail
     */
    public function mail()
    {
        if (!isset($this->api[__FUNCTION__])) {
            $this->api[__FUNCTION__] = new Mail\IndexMail();
        }

        return $this->api[__FUNCTION__];
    }

    /**
     * @return Configuration\IndexConfiguration
     */
    public function configuration()
    {
        if (!isset($this->api[__FUNCTION__])) {
            $this->api[__FUNCTION__] = new Configuration\IndexConfiguration($this->container);
        }

        return $this->api[__FUNCTION__];
    }

    /**
     * @return ValidatorInterface
     */
    public function validator()
    {
        return $this->container->get('validator');
    }

    /**
     * @return \Symfony\Component\HttpKernel\Profiler\Profiler
     */
    public function profiler()
    {
        return $this->container->has('profiler') ? $this->container->get('profiler') : null;
    }

    /**
     * @return Controller\IndexController
     */
    public function controller()
    {
        if (!isset($this->api[__FUNCTION__])) {
            $this->api[__FUNCTION__] = new Controller\IndexController($this);
        }

        return $this->api[__FUNCTION__];
    }

    /**
     * @return Credentials\Index
     */
    public function credentials()
    {
        if (!isset($this->api[__FUNCTION__])) {
            $this->api[__FUNCTION__] = new Credentials\Index($this);
        }

        return $this->api[__FUNCTION__];
    }

    /**
     * Database manager
     * @return \Sso\WebserviceBundle\Database\Manager
     */
    public function database()
    {
        return $this->container->get('service_database_manager');
    }

    /**
     *
     * @return \Sso\Tools\UserIdentifierBundle\Api\ControllerInterface
     */
    public function userService()
    {
        return $this->container->get('sso_tools_user_identifier.api_controller');
    }

    /**
     * @return float
     */
    public function scriptTimeSeconds()
    {
        return $this->container->get('webservice.performance.listener')->getScriptSeconds();
    }

    /**
     * @return SerializerInterface
     */
    public function serializer()
    {
        return $this->container->get('jms_serializer');
    }

    /**
     * @return SerializerInterface
     */
    public function customSerializer()
    {
        return $this->container->get('custom_serializer_datetime_insensitive');
    }

    /**
     * @return ErrorHandler
     */
    public function errorHandler()
    {
        return $this->container->get('webservice.error_handler.handler');
    }

    /**
     * @return MfaCreator
     */
    public function mfaCreator()
    {
        return $this->container->get('mfa_api_manager')->mfa()->create();
    }

    /**
     * @return Mapper\Index
     */
    public function mapper()
    {
        if (!isset($this->api[__FUNCTION__])) {
            $this->api[__FUNCTION__] = new Mapper\Index($this);
        }

        return $this->api[__FUNCTION__];
    }

    /**
     * @deprecated Since version 1.0.22. Use AuthorizationManager::getUserRolesApplicationRead() instead
     * @return array
     */
    public function userRolesApplicationRead()
    {
        return $this->container->get('sso_webservice.api.authorization_manager')->getUserRolesApplicationRead();
    }

    /**
     * @deprecated Since version 1.0.22. Use AuthorizationManager::getUserRolesApplicationWrite() instead
     * @return array
     */
    public function userRolesApplicationWrite()
    {
        return $this->container->get('sso_webservice.api.authorization_manager')->getUserRolesApplicationWrite();
    }

    /**
     * @return UserAuthorization
     */
    public function userAuthorization(): UserAuthorization
    {
        return $this->container->get('sso_webservice.security_authorisation.user_authorization');
    }

    /**
     * @return HistoryService
     */
    public function passwordHistory()
    {
        return $this->container->get('sso_webservice.passwordpolicy.history.service');
    }

    /**
     * @return PasswordPolicy\Policy\Service
     */
    public function passwordPolicy()
    {
        return $this->container->get('sso_webservice.passwordpolicy.policy.service');
    }

    /**
     * @return PasswordCryptRepositoryInterface
     */
    public function passwordCryptRepository(): PasswordCryptRepositoryInterface
    {
        return $this->container->get('password_crypt_repository');
    }
}
