<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Api\PasswordPolicy\Policy\Model;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Policy
 * @package Sso\WebserviceBundle\Api\PasswordPolicy\Policy\Model
 */
final class Policy
{
    /**
     * @var string
     */
    private $policyId;

    /**
     * @var string|null
     */
    private $regEx;

    /**
     * @var integer
     */
    private $validityDuration;

    /**
     * @var integer
     */
    private $historySize;

    /**
     * @var integer
     */
    private $editDistance;

    /**
     * @var integer
     */
    private $changeDelay;

    /**
     * @var string
     */
    private $policyDescription;

    /**
     * @var array
     */
    private $regexErrorMessages = [];

    /**
     * @var array
     */
    private $historySizeErrorMessages = [];

    /**
     * @var array
     */
    private $editDistanceErrorMessages = [];

    /**
     * @var array
     */
    private $changeDelayErrorMessages = [];

    /**
     * @var array
     */
    private $errorMessages = [];

    /**
     * @var PolicyValidations[]|ArrayCollection
     */
    private $policyValidations;

    /**
     * Policy constructor.
     */
    public function __construct()
    {
        $this->policyValidations = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getPolicyId()
    {
        return $this->policyId;
    }

    /**
     * @param string $policyId
     * @return Policy
     */
    public function setPolicyId($policyId)
    {
        $this->policyId = $policyId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getRegEx()
    {
        return $this->regEx;
    }

    /**
     * @param string|null $regEx
     * @return Policy
     */
    public function setRegEx($regEx)
    {
        $this->regEx = $regEx;
        return $this;
    }

    /**
     * @return int
     */
    public function getValidityDuration()
    {
        return $this->validityDuration;
    }

    /**
     * @param int $validityDuration
     * @return Policy
     */
    public function setValidityDuration($validityDuration)
    {
        $this->validityDuration = $validityDuration;
        return $this;
    }

    /**
     * @return int
     */
    public function getHistorySize()
    {
        return $this->historySize;
    }

    /**
     * @param int $historySize
     * @return Policy
     */
    public function setHistorySize($historySize)
    {
        $this->historySize = $historySize;
        return $this;
    }

    /**
     * @return int
     */
    public function getEditDistance()
    {
        return $this->editDistance;
    }

    /**
     * @param int $editDistance
     * @return Policy
     */
    public function setEditDistance($editDistance)
    {
        $this->editDistance = $editDistance;
        return $this;
    }

    /**
     * @return int
     */
    public function getChangeDelay()
    {
        return $this->changeDelay;
    }

    /**
     * @param int $changeDelay
     * @return Policy
     */
    public function setChangeDelay($changeDelay)
    {
        $this->changeDelay = $changeDelay;
        return $this;
    }

    /**
     * @return string
     */
    public function getPolicyDescription()
    {
        return $this->policyDescription;
    }

    /**
     * @param string $policyDescription
     * @return Policy
     */
    public function setPolicyDescription($policyDescription)
    {
        $this->policyDescription = $policyDescription;
        return $this;
    }

    /**
     * @return array
     */
    public function getRegexErrorMessages()
    {
        return $this->regexErrorMessages;
    }

    /**
     * @param array $regexErrorMessages
     * @return Policy
     */
    public function setRegexErrorMessages($regexErrorMessages)
    {
        $this->regexErrorMessages = $regexErrorMessages;
        return $this;
    }

    /**
     * @return array
     */
    public function getHistorySizeErrorMessages()
    {
        return $this->historySizeErrorMessages;
    }

    /**
     * @param array $historySizeErrorMessages
     * @return Policy
     */
    public function setHistorySizeErrorMessages($historySizeErrorMessages)
    {
        $this->historySizeErrorMessages = $historySizeErrorMessages;
        return $this;
    }

    /**
     * @return array
     */
    public function getEditDistanceErrorMessages()
    {
        return $this->editDistanceErrorMessages;
    }

    /**
     * @param array $editDistanceErrorMessages
     * @return Policy
     */
    public function setEditDistanceErrorMessages($editDistanceErrorMessages)
    {
        $this->editDistanceErrorMessages = $editDistanceErrorMessages;
        return $this;
    }

    /**
     * @return array
     */
    public function getChangeDelayErrorMessages()
    {
        return $this->changeDelayErrorMessages;
    }

    /**
     * @param array $changeDelayErrorMessages
     * @return Policy
     */
    public function setChangeDelayErrorMessages($changeDelayErrorMessages)
    {
        $this->changeDelayErrorMessages = $changeDelayErrorMessages;
        return $this;
    }

    /**
     * @return array
     */
    public function getErrorMessages()
    {
        return $this->errorMessages;
    }

    /**
     * @param array $errorMessages
     * @return Policy
     */
    public function setErrorMessages($errorMessages)
    {
        $this->errorMessages = $errorMessages;
        return $this;
    }

    /**
     * @return PolicyValidations[]|ArrayCollection
     */
    public function getPolicyValidations()
    {
        return $this->policyValidations;
    }

    /**
     * @param PolicyValidations $policyValidation
     * @return Policy
     */
    public function addPolicyValidation($policyValidation)
    {
        if (!$this->policyValidations->contains($policyValidation)) {
            $this->policyValidations->add($policyValidation);
        }
        return $this;
    }
}
