<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Api\PasswordPolicy\User\Model;

/**
 * Class UserPasswordResetCheckResponse
 * @package Sso\WebserviceBundle\Services\PasswordPolicy\User\Model
 */
final class UserPasswordResetCheckResponse
{
    /**
     * @var UsersPasswordPolicy
     */
    private $passwordPolicy;

    /**
     * @var boolean
     */
    private $passwordExpired = false;

    /**
     * @var boolean
     */
    private $forcePasswordReset = false;

    /**
     * @var \DateTime
     */
    private $passwordValidUntil;

    /**
     * @var string
     */
    private $resetPasswordToken;

    /**
     * @var \DateTime
     */
    private $resetPasswordTokenExpire;

    /**
     * @return UsersPasswordPolicy
     */
    public function getPasswordPolicy()
    {
        return $this->passwordPolicy;
    }

    /**
     * @param UsersPasswordPolicy $passwordPolicy
     * @return UserPasswordResetCheckResponse
     */
    public function setPasswordPolicy(UsersPasswordPolicy $passwordPolicy)
    {
        $this->passwordPolicy = $passwordPolicy;
        return $this;
    }

    /**
     * @param bool $passwordExpired
     * @return UserPasswordResetCheckResponse
     */
    public function setPasswordExpired($passwordExpired)
    {
        $this->passwordExpired = $passwordExpired;
        return $this;
    }

    /**
     * @return bool
     */
    public function isForcePasswordReset()
    {
        return $this->forcePasswordReset;
    }

    /**
     * @param bool $forcePasswordReset
     * @return UserPasswordResetCheckResponse
     */
    public function setForcePasswordReset($forcePasswordReset)
    {
        $this->forcePasswordReset = $forcePasswordReset;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getPasswordValidUntil()
    {
        return $this->passwordValidUntil;
    }

    /**
     * @param \DateTime $passwordValidUntil
     * @return UserPasswordResetCheckResponse
     */
    public function setPasswordValidUntil($passwordValidUntil)
    {
        $this->passwordValidUntil = $passwordValidUntil;
        return $this;
    }

    /**
     * @return string
     */
    public function getResetPasswordToken()
    {
        return $this->resetPasswordToken;
    }

    /**
     * @param string $resetPasswordToken
     * @return UserPasswordResetCheckResponse
     */
    public function setResetPasswordToken($resetPasswordToken)
    {
        $this->resetPasswordToken = $resetPasswordToken;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getResetPasswordTokenExpire()
    {
        return $this->resetPasswordTokenExpire;
    }

    /**
     * @param \DateTime $resetPasswordTokenExpire
     * @return UserPasswordResetCheckResponse
     */
    public function setResetPasswordTokenExpire($resetPasswordTokenExpire)
    {
        $this->resetPasswordTokenExpire = $resetPasswordTokenExpire;
        return $this;
    }
}
