<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Api\Serializer;

use JMS\Serializer\Exception\RuntimeException;
use JMS\Serializer\Handler\DateHandler;
use JMS\Serializer\XmlDeserializationVisitor;

/**
 * Class DateTimeHandler
 * @package Sso\WebserviceBundle\Api\Serializer
 */
class DateTimeHandler extends DateHandler
{
    /**
     * @param XmlDeserializationVisitor $visitor
     * @param $data
     * @param array $type
     *
     * @return \DateTime|null|false
     */
    public function deserializeDateTimeFromXml(XmlDeserializationVisitor $visitor, $data, array $type)
    {
        if ((string)$data === '') {
            return null;
        }
        try {
            $result = parent::deserializeDateTimeFromXml($visitor, $data, $type);
        } catch (RuntimeException $exception) {
            return false;
        }
        return $result;
    }
}
