<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\DataFixtures\ORM\ReadWrite;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\Persistence\ObjectManager;
use LifeStyle\Tools\RestAuthBundle\Entity\Usage\WsseTokens;

/**
 * Class LoadWsseTokens
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\DataFixtures\ORM\ReadWrite
 */
class LoadWsseTokens extends AbstractFixture
{
    /**
     * Load data fixtures with the passed EntityManager
     *
     * @param ObjectManager $manager
     */
    public function load(ObjectManager $manager)
    {
        // Create dummy entry to make sure table exists
        $entity = new WsseTokens();
        $entity->setCreatedAt();
        $entity->setNonce('');
        $entity->setPasswordDigest('');
        $entity->setRequestCreated('');
        $entity->setUserName('');

        $manager->persist($entity);
        $manager->flush();
    }
}
