<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Sso\WebserviceBundle\Entity\ServiceProvider\Type\Service;

/**
 * Class LoadServices
 * @package Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider
 */
class LoadServices extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $rows = array(
            array('intern', 'Application', 'All', 'no'),
            array('intern', 'Application', 'Add', 'no'),
            array('intern', 'Application', 'Delete', 'no'),
            array('intern', 'Application', 'Show', 'no'),
            array('intern', 'ApplicationAttribute', 'Add', 'no'),
            array('intern', 'ApplicationAttribute', 'Delete', 'no'),
            array('intern', 'ApplicationAttribute', 'Show', 'no'),
            array('intern', 'ApplicationRole', 'Add', 'no'),
            array('intern', 'ApplicationRole', 'Delete', 'no'),
            array('intern', 'ApplicationRole', 'Show', 'no'),
            array('intern', 'User', 'Add', 'no'),
            array('intern', 'User', 'Delete', 'no'),
            array('intern', 'User', 'ChangePassword', 'no'),
            array('intern', 'User', 'Update', 'no'),
            array('intern', 'User', 'Show', 'no'),
            array('intern', 'UserApplication', 'Add', 'no'),
            array('intern', 'UserApplication', 'Delete', 'no'),
            array('intern', 'UserApplication', 'Show', 'no'),
            array('intern', 'UserApplication', 'ShowDetails', 'no'),
            array('intern', 'UserApplicationAttribute', 'Add', 'no'),
            array('intern', 'UserApplicationAttribute', 'Delete', 'no'),
            array('intern', 'UserApplicationAttribute', 'Show', 'no'),
            array('intern', 'UserApplicationRole', 'Add', 'no'),
            array('intern', 'UserApplicationRole', 'Delete', 'no'),
            array('intern', 'UserApplicationRole', 'Show', 'no'),
            array('intern', 'UserSearch', 'FindByApplication', 'no'),
            array('intern', 'UserSearch', 'FindByApplicationAttribute', 'no'),
            array('intern', 'UserSearch', 'FindByApplicationRole', 'no'),
            array('intern', 'UserService', 'ActivateConfirm', 'no'),
            array('intern', 'UserService', 'ActivateRequest', 'no'),
            array('intern', 'UserService', 'PasswordConfirm', 'no'),
            array('intern', 'UserService', 'PasswordRequest', 'no'),
        );
        foreach ($rows as $row) {
            $entity = new Service();
            $entity->setServiceType($row[0])
                    ->setServiceController($row[1])
                    ->setServiceAction($row[2])
                    ->setServiceMapped2Group($row[3]);
            $manager->persist($entity);
        }
        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 2;
    }
}
