<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Sso\WebserviceBundle\Entity\ServiceProvider\Type\Token;

/**
 * Class LoadTokens
 * @package Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider
 */
class LoadTokens extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $tenYears = new \DateTime();
        $tenYears->add(new \DateInterval('P10Y'));
        $rows = array(
            array(
                'V2030cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa', '*', 100, $tenYears, 0, null, 'Default entry for testing'
            )
        );
        foreach ($rows as $row) {
            $entity = new Token();
            $entity->setServiceToken($row[0])
                    ->setServiceToken2Ip($row[1])
                    ->setAllowedCallsPerDay($row[2])
                    ->setValidUntil($row[3])
                    ->setBlocked($row[4])
                    ->setBlockedReason($row[5])
                    ->setDescription($row[6]);
            $manager->persist($entity);
        }
        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 3;
    }
}
