<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Database;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface as Validator;
use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;

/**
 * Class Manager
 * @package Sso\WebserviceBundle\Database
 */
class Manager
{
    /**
     * @var ContainerInterface
     */
    protected $container;

    /**
     * @var DoctrineRegistry
     */
    protected $registry;

    /**
     * Validator
     *
     * @var Validator
     */
    protected $validator;

    /**
     * @var boolean
     */
    protected $webserviceReadonly;

    /**
     * List of databases
     *
     * @var array
     */
    protected $factory = array();

    /**
     * Manager constructor.
     * @param ContainerInterface $container
     * @param DoctrineRegistry $registry
     * @param Validator $validator
     * @param bool $webserviceReadonly
     */
    public function __construct(
        ContainerInterface $container,
        DoctrineRegistry $registry,
        Validator $validator,
        bool $webserviceReadonly
    ) {
        $this->container = $container;
        $this->registry = $registry;
        $this->validator = $validator;
        $this->webserviceReadonly = $webserviceReadonly;
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\Manager
     */
    public function webservice()
    {
        return $this->container->get('sso_webservice.database_webservice.manager');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\ServiceProvider\Manager
     */
    public function serviceProvider()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ServiceProvider\Manager($this->_getEntityManager('ServiceProvider'), $this->validator, $this->webserviceReadonly));
    }

    /**
     * @param string $entityManagerName
     * @return \Doctrine\ORM\EntityManager
     */
    private function _getEntityManager($entityManagerName)
    {
        return $this->registry->getManager($entityManagerName);
    }
}
