<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Database\Webservice;

use Sso\WebserviceBundle\Entity\Webservice\Type\User as ModelUser;
use Doctrine\ORM\EntityRepository;

/**
 * Class Firewall
 * @package Sso\WebserviceBundle\Database\Webservice
 */
class Firewall extends Base
{

    /**
     * @param $username
     * @param string $appName
     * @return null|ModelUser
     */
    public function userHasApplication($username, $appName){

        return $this->getUserRepository()
            ->createQueryBuilder('u')
            ->join('u.UserApplications', 'ua')
            ->where('u.LowerUsername LIKE :LowerUsername')
            ->andWhere('ua.Name=:UaName')
            ->andWhere('ua.Active=:Active')
            ->setParameter('LowerUsername', $username)
            ->setParameter('UaName', $appName)
            ->setParameter('Active', 1)
            ->getQuery()
            ->getOneOrNullResult();
    }

    /**
     * @return EntityRepository
     */
    public function getUserRepository()
    {
        return $this->entityManager->getRepository('Sso\WebserviceBundle\Entity\Webservice\Type\User');
    }
}
