<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Database\Webservice;

use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class Manager
 * @deprecated Use Symfony dependency injection instead
 * @package Sso\WebserviceBundle\Database\Webservice
 */
class Manager
{
    /**
     * @var ContainerInterface
     */
    protected $container;

    /**
     * Manager constructor.
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\User
     */
    public function user()
    {
        return $this->container->get('sso_webservice.database_webservice.user');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\UserGroup
     */
    public function userGroup()
    {
        return $this->container->get('sso_webservice.database_webservice.user_group');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\Firewall
     */
    public function firewall()
    {
        return $this->container->get('sso_webservice.database_webservice.firewall');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\UserApplication
     */
    public function userApplication()
    {
        return $this->container->get('sso_webservice.database_webservice.user_application');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\UserApplicationAttribute
     */
    public function userApplicationAttribute()
    {
        return $this->container->get('sso_webservice.database_webservice.user_application_attribute');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\UserApplicationRole
     */
    public function userApplicationRole()
    {
        return $this->container->get('sso_webservice.database_webservice.user_application_role');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\Application
     */
    public function application()
    {
        return $this->container->get('sso_webservice.database_webservice.application');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\Role
     */
    public function role()
    {
        return $this->container->get('sso_webservice.database_webservice.role');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\Attribute
     */
    public function attribute()
    {
        return $this->container->get('sso_webservice.database_webservice.attribute');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\AttributeValue
     */
    public function attributeValue()
    {
        return $this->container->get('sso_webservice.database_webservice.attribute_value');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\PasswordPolicy
     */
    public function passwordPolicy()
    {
        return $this->container->get('sso_webservice.database_webservice.password_policy');
    }

    /**
     * @return \Sso\WebserviceBundle\Database\Webservice\PasswordHistory
     */
    public function passwordHistory()
    {
        return $this->container->get('sso_webservice.database_webservice.password_history');
    }
}
