<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Database\Webservice;

use Sso\WebserviceBundle\Entity\Webservice\Type;

/**
 * Class UserApplicationAttribute
 * @package Sso\WebserviceBundle\Database\Webservice
 */
class UserApplicationAttribute extends Base
{
    /**
     * @param Type\Attribute $attribute
     */
    public function updateAttribute(Type\Attribute $attribute)
    {
        $dql = 'UPDATE Sso\WebserviceBundle\Entity\Webservice\Type\UserApplicationAttribute uaa '
            . 'SET uaa.Name=:name '
            . 'WHERE uaa.Attribute=:attribute';
        $query = $this->entityManager->createQuery($dql);
        $query->setParameter('name', $attribute->getName());
        $query->setParameter('attribute', $attribute);
        $query->execute();
    }

    /**
     * Find user appliction value by id
     * @param string $userApplicationAttributeId
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\UserApplicationAttribute|null
     */
    public function getUserApplicationAttributeById($userApplicationAttributeId)
    {
        return $this->getRepository()->find($userApplicationAttributeId);
    }

    /**
     * Save user application attribute
     * @param Type\UserApplicationAttribute $entity
     * @return boolean
     */
    public function saveUserApplicationAttribute(Type\UserApplicationAttribute $entity)
    {
        $entity->setValidator($this->validator);
        if (!$entity->isValid()) {
            return false;
        }

        if ($this->readonly) {
            return false;
        }

        $this->entityManager->persist($entity);
        $this->entityManager->flush();

        return true;
    }

    /**
     * Save user-application-link to database
     * @param array $userApplicationAttributes
     * @return boolean
     */
    public function saveUserApplicationAttributes(array $userApplicationAttributes)
    {
        // Do default validation
        $isValid = true;
        foreach ($userApplicationAttributes as $entity) {
            $entity->setValidator($this->validator);
            if (!$entity->isValid()) {
                $isValid = false;
            }
        }
        if (!$isValid) {
            return false;
        }

        if ($this->readonly) {
            return false;
        }

        foreach ($userApplicationAttributes as $entity) {
            $this->entityManager->persist($entity);
        }
        $this->entityManager->flush();

        return true;
    }

    /**
     * Delete all existing attribute values from users application
     * @param array $entities List of \Sso\WebserviceBundle\Entity\Webservice\Type\UserApplication
     * @return bool
     */
    public function deleteUserApplicationAttributes($entities)
    {
        // Do default validation
        $isValid = true;
        foreach ($entities as $entity) {
            $entity->setValidator($this->validator);
            if (!$entity->isValid()) {
                $isValid = false;
            }
        }
        if (!$isValid) {
            return false;
        }

        if ($this->readonly) {
            return false;
        }

        foreach ($entities as $entity) {
            $this->entityManager->remove($entity);
        }

        $this->entityManager->flush();

        return true;
    }

    /**
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\UserApplicationAttribute
     */
    public function getRepository()
    {
        return $this->entityManager->getRepository('Sso\WebserviceBundle\Entity\Webservice\Type\UserApplicationAttribute');
    }
}
