<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Database\Webservice;

use Sso\WebserviceBundle\Entity\Webservice\Type;

/**
 * Class UserApplicationRole
 * @package Sso\WebserviceBundle\Database\Webservice
 */
class UserApplicationRole extends Base
{
    /**
     * @param Type\Attribute $attribute
     */
    public function updateRole(Type\Role $role)
    {
        $dql = 'UPDATE Sso\WebserviceBundle\Entity\Webservice\Type\UserApplicationRole uaa '
            . 'SET uaa.Name=:name '
            . 'WHERE uaa.Role=:role';
        $query = $this->entityManager->createQuery($dql);
        $query->setParameter('name', $role->getName());
        $query->setParameter('role', $role);
        $query->execute();
    }

    /**
     * Save user application role to database
     * @param Type\UserApplicationRole $typeRole
     * @return bool Returns true on success, false on validation failure
     */
    public function saveUserApplicationRole(Type\UserApplicationRole $typeRole)
    {
        // Do default validation
        $typeRole->setValidator($this->validator);
        if (!$typeRole->isValid()) {
            return false;
        }

        if ($this->readonly) {
            return false;
        }

        $this->entityManager->persist($typeRole);
        $this->entityManager->flush($typeRole);

        // for user updateDate
        $this->entityManager->flush();

        return true;
    }

    /**
     * Find user application role by id
     * @param string $userApplicationRoleId
     * @return null|Type\UserApplicationRole
     */
    public function getUserApplicationRoleById($userApplicationRoleId)
    {
        return $this->getRepository()->find($userApplicationRoleId);
    }

    /**
     * Add roles to users application
     * @param array $userApplicationRoles
     * @return bool
     */
    public function addUserApplicationRoles(array $userApplicationRoles)
    {
        $valid = true;
        foreach ($userApplicationRoles as $role) {
            $role->setValidator($this->validator);
            if (!$role->validate()) {
                $valid = false;
            }
        }
        if (!$valid) {
            return false;
        }

        if ($this->readonly) {
            return false;
        }

        foreach ($userApplicationRoles as $role) {
            $this->entityManager->persist($role);
            $this->entityManager->flush($role);
        }

        // for user updateDate
        $this->entityManager->flush();

        return true;
    }

    /**
     * Delete roles from users applicaion
     * @param array $userApplicationRoles
     * @return bool
     */
    public function deleteUserApplicationRoles(array $userApplicationRoles)
    {
        $userEntity = null;
        foreach ($userApplicationRoles as $role) {
            if(!$userEntity){
                $userEntity = $role->getUserApplication()->getUser();
            }

            if ($this->readonly) {
                return false;
            }

            $this->entityManager->remove($role);
            $this->entityManager->flush($role);
        }

        // for user updateDate
        if($userEntity) {
            $this->entityManager->persist($userEntity);
            $this->entityManager->flush($userEntity);
        }
        return true;
    }

    /**
     * @return Type\UserApplicationRole
     */
    public function getRepository()
    {
        return $this->entityManager->getRepository('Sso\WebserviceBundle\Entity\Webservice\Type\UserApplicationRole');
    }
}
