<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class ApplicationAttributeGeneratorPass
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\DependencyInjection\Compiler
 */
class ApplicationAttributeGeneratorPass implements CompilerPassInterface
{
    use PriorityTaggedServiceTrait;

    const TAG_NAME = 'sso_webservice.application_attribute_generator';

    /**
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        if (!$container->has('sso_webservice.validator_constraints.application_attribute_value_validator')) {
            return;
        }

        $validatorDefinition = $container->findDefinition('sso_webservice.validator_constraints.application_attribute_value_validator');
        $handlerDefinition = $container->findDefinition('sso_webservice.services_user_application_attribute_add.handler');

        $taggedServices = $this->findAndSortTaggedServices(self::TAG_NAME, $container);
        foreach ($taggedServices as $taggedService) {
            $validatorDefinition->addMethodCall('addGenerator', array($taggedService));
            $handlerDefinition->addMethodCall('addAttributeGenerator', array($taggedService));
        }
    }
}
