<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\DependencyInjection;

use Sso\WebserviceBundle\PasswordCrypt\PasswordCryptInterface;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 * @package Sso\WebserviceBundle\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritDoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('sso_webservice');

        $rootNode
            ->children()
                ->arrayNode('feature_toggle')
                    ->performNoDeepMerging()
                    ->prototype('array')
                        ->children()
                            ->scalarNode('enabled')
                                ->defaultTrue()
                                ->validate()
                                    ->ifNotInArray(['false', false, '0', 0, 'true', true, '1', 1])
                                    ->thenInvalid('Invalid feature toggle: value should be false, 0, true or 1.')
                                ->end()
                                ->info('Set this value to true')
                            ->end()
                            ->scalarNode('condition')
                                ->defaultNull()
                                ->info('The condition is optional. Use the Symfony Expression Syntax. The following variables are passed into the expression: context (RequestContext), request (Request).')
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end();

        $rootNode->children()
            ->integerNode('password_history_size')
            ->isRequired()
            ->end();

        $rootNode->children()
            ->scalarNode('password_encrypt_default_type')
            ->defaultValue('default')
            ->info('The default password encryption algorithm. Watch out for services with interface ' . PasswordCryptInterface::class)
            ->end();

        $rootNode
            ->children()
                ->arrayNode('security')
                    ->isRequired()
                    ->children()
                        ->scalarNode('user_access_application')
                            ->cannotBeEmpty()
                            ->example('UserConfiguration')
                            ->info('If the used service token has set the restricted-access-flag, the list of accessible applications including read/write permissions will be read from this user-application instead of the WebserviceConsumer application.')
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;
        return $treeBuilder;
    }
}
