<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Entity\ServiceProvider\Type;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class Service
 * @package Sso\WebserviceBundle\Entity\ServiceProvider\Type
 */
class Service
{
    /**
     * @var integer
     */
    private $ServiceId;

    /**
     * @var string
     */
    private $ServiceType;

    /**
     * @var string
     */
    private $ServiceController;

    /**
     * @var string
     */
    private $ServiceAction;

    /**
     * @var string
     */
    private $ServiceMapped2Group;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $ServiceNames;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->ServiceNames = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get ServiceId
     *
     * @return integer 
     */
    public function getServiceId()
    {
        return $this->ServiceId;
    }

    /**
     * Set ServiceType
     *
     * @param string $serviceType
     * @return Service
     */
    public function setServiceType($serviceType)
    {
        $this->ServiceType = $serviceType;

        return $this;
    }

    /**
     * Get ServiceType
     *
     * @return string 
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }

    /**
     * Set ServiceController
     *
     * @param string $serviceController
     * @return Service
     */
    public function setServiceController($serviceController)
    {
        $this->ServiceController = $serviceController;

        return $this;
    }

    /**
     * Get ServiceController
     *
     * @return string 
     */
    public function getServiceController()
    {
        return $this->ServiceController;
    }

    /**
     * Set ServiceAction
     *
     * @param string $serviceAction
     * @return Service
     */
    public function setServiceAction($serviceAction)
    {
        $this->ServiceAction = $serviceAction;

        return $this;
    }

    /**
     * Get ServiceAction
     *
     * @return string 
     */
    public function getServiceAction()
    {
        return $this->ServiceAction;
    }

    /**
     * Set ServiceMapped2Group
     *
     * @param string $serviceMapped2Group
     * @return Service
     */
    public function setServiceMapped2Group($serviceMapped2Group)
    {
        $this->ServiceMapped2Group = $serviceMapped2Group;

        return $this;
    }

    /**
     * Get ServiceMapped2Group
     *
     * @return string 
     */
    public function getServiceMapped2Group()
    {
        return $this->ServiceMapped2Group;
    }

    /**
     * Add ServiceNames
     *
     * @param \Sso\WebserviceBundle\Entity\ServiceProvider\Type\ServiceName $serviceNames
     * @return Service
     */
    public function addServiceName(\Sso\WebserviceBundle\Entity\ServiceProvider\Type\ServiceName $serviceNames)
    {
        $this->ServiceNames[] = $serviceNames;

        return $this;
    }

    /**
     * Remove ServiceNames
     *
     * @param \Sso\WebserviceBundle\Entity\ServiceProvider\Type\ServiceName $serviceNames
     */
    public function removeServiceName(\Sso\WebserviceBundle\Entity\ServiceProvider\Type\ServiceName $serviceNames)
    {
        $this->ServiceNames->removeElement($serviceNames);
    }

    /**
     * Get ServiceNames
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getServiceNames()
    {
        return $this->ServiceNames;
    }
}
