<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Entity\ServiceProvider\Type;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class TokenUsage
 * @package Sso\WebserviceBundle\Entity\ServiceProvider\Type
 */
class TokenUsage
{

    /**
     * @var string
     */
    private $UsageId;

    /**
     * @var string
     */
    private $ServiceToken;

    /**
     * @var \DateTime
     */
    private $Date;

    /**
     * @var string
     */
    private $Ip;

    /**
     * @var string
     */
    private $Controller;

    /**
     * @var string
     */
    private $Action;

    /**
     * @var \Sso\WebserviceBundle\Entity\ServiceProvider\Type\Token
     */
    private $Token;

    /**
     * Init usage id with unique random value
     */
    public function initUsageId()
    {
        $this->setUsageId(hash('sha256', mt_rand() . '#' . microtime()));
    }

    /**
     * Set UsageId
     *
     * @param string $usageId
     * @return TokenUsage
     */
    public function setUsageId($usageId)
    {
        $this->UsageId = $usageId;

        return $this;
    }

    /**
     * Get UsageId
     *
     * @return string 
     */
    public function getUsageId()
    {
        return $this->UsageId;
    }

    /**
     * Set ServiceToken
     *
     * @param string $serviceToken
     * @return TokenUsage
     */
    public function setServiceToken($serviceToken)
    {
        $this->ServiceToken = $serviceToken;

        return $this;
    }

    /**
     * Get ServiceToken
     *
     * @return string 
     */
    public function getServiceToken()
    {
        return $this->ServiceToken;
    }

    /**
     * Set Date
     *
     * @param \DateTime $date
     * @return TokenUsage
     */
    public function setDate($date)
    {
        $this->Date = $date;

        return $this;
    }

    /**
     * Get Date
     *
     * @return \DateTime 
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     * Set Ip
     *
     * @param string $ip
     * @return TokenUsage
     */
    public function setIp($ip)
    {
        $this->Ip = $ip;

        return $this;
    }

    /**
     * Get Ip
     *
     * @return string 
     */
    public function getIp()
    {
        return $this->Ip;
    }

    /**
     * Set Controller
     *
     * @param string $controller
     * @return TokenUsage
     */
    public function setController($controller)
    {
        $this->Controller = $controller;

        return $this;
    }

    /**
     * Get Controller
     *
     * @return string 
     */
    public function getController()
    {
        return $this->Controller;
    }

    /**
     * Set Action
     *
     * @param string $action
     * @return TokenUsage
     */
    public function setAction($action)
    {
        $this->Action = $action;

        return $this;
    }

    /**
     * Get Action
     *
     * @return string 
     */
    public function getAction()
    {
        return $this->Action;
    }

    /**
     * Set Token
     *
     * @param \Sso\WebserviceBundle\Entity\ServiceProvider\Type\Token $token
     * @return TokenUsage
     */
    public function setToken(\Sso\WebserviceBundle\Entity\ServiceProvider\Type\Token $token = null)
    {
        $this->Token = $token;

        return $this;
    }

    /**
     * Get Token
     *
     * @return \Sso\WebserviceBundle\Entity\ServiceProvider\Type\Token
     */
    public function getToken()
    {
        return $this->Token;
    }

    /**
     * Validate model
     * 
     * @return bool
     */
    public function isValid()
    {
        return null !== $this->Token;
    }

    /**
     * @var string
     */
    private $TrackId;

    /**
     * Set TrackId
     *
     * @param string $trackId
     * @return TokenUsage
     */
    public function setTrackId($trackId)
    {
        $this->TrackId = $trackId;

        return $this;
    }

    /**
     * Get TrackId
     *
     * @return string 
     */
    public function getTrackId()
    {
        return $this->TrackId;
    }

    /**
     * @var string
     */
    private $Status;

    /**
     * Set Status
     *
     * @param string $status
     * @return TokenUsage
     */
    public function setStatus($status)
    {
        $this->Status = $status;

        return $this;
    }

    /**
     * Get Status
     *
     * @return string 
     */
    public function getStatus()
    {
        return $this->Status;
    }
}
