<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Entity\Webservice\Type;

/**
 * Class PasswordHistory
 * @package Sso\WebserviceBundle\Entity\Webservice\Type
 */
class PasswordHistory
{
    /**
     * @var string
     */
    private $passwordId;

    /**
     * @var string
     */
    private $userGuid;

    /**
     * @var string
     */
    private $password;

    /**
     * @var \DateTime
     */
    private $addedAt;

    /**
     * @var string
     */
    private $passwordEncryptType;

    /**
     * @return string
     */
    public function getPasswordId()
    {
        return $this->passwordId;
    }

    /**
     * @param string $passwordId
     * @return PasswordHistory
     */
    public function setPasswordId($passwordId)
    {
        $this->passwordId = $passwordId;
        return $this;
    }

    /**
     * @return string
     */
    public function getUserGuid()
    {
        return $this->userGuid;
    }

    /**
     * @param string $userGuid
     * @return PasswordHistory
     */
    public function setUserGuid($userGuid)
    {
        $this->userGuid = $userGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string $password
     * @return PasswordHistory
     */
    public function setPassword($password)
    {
        $this->password = $password;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getAddedAt()
    {
        return $this->addedAt;
    }

    /**
     * @param \DateTime $addedAt
     * @return PasswordHistory
     */
    public function setAddedAt($addedAt)
    {
        $this->addedAt = $addedAt;
        return $this;
    }

    /**
     * @return string
     */
    public function getPasswordEncryptType(): string
    {
        return $this->passwordEncryptType;
    }

    /**
     * @param string $passwordEncryptType
     */
    public function setPasswordEncryptType(string $passwordEncryptType): void
    {
        $this->passwordEncryptType = $passwordEncryptType;
    }
}
