<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Entity\Webservice\Type;

/**
 * Class PasswordPolicyValidations
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Entity\Webservice\Type
 */
class PasswordPolicyValidations
{
    /**
     * @var string
     */
    private $validationId;

    /**
     * @var integer
     */
    private $orderId;

    /**
     * @var string
     */
    private $regEx;

    /**
     * @var array
     */
    private $errorMessages;

    /**
     * @var array
     */
    private $hintMessages;

    /**
     * @var PasswordPolicy
     */
    private $passwordPolicy;

    /**
     * @return string
     */
    public function getValidationId()
    {
        return $this->validationId;
    }

    /**
     * @param string $validationId
     * @return PasswordPolicyValidations
     */
    public function setValidationId($validationId)
    {
        $this->validationId = $validationId;
        return $this;
    }

    /**
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param int $orderId
     * @return PasswordPolicyValidations
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    /**
     * @return string
     */
    public function getRegEx()
    {
        return $this->regEx;
    }

    /**
     * @param string $regEx
     * @return PasswordPolicyValidations
     */
    public function setRegEx($regEx)
    {
        $this->regEx = $regEx;
        return $this;
    }

    /**
     * @return array
     */
    public function getErrorMessages()
    {
        return $this->errorMessages;
    }

    /**
     * @param array $errorMessages
     */
    public function setErrorMessages($errorMessages)
    {
        $this->errorMessages = $errorMessages;
    }

    /**
     * @return array
     */
    public function getHintMessages()
    {
        return $this->hintMessages;
    }

    /**
     * @param array $hintMessages
     */
    public function setHintMessages($hintMessages)
    {
        $this->hintMessages = $hintMessages;
    }

    /**
     * @return PasswordPolicy
     */
    public function getPasswordPolicy()
    {
        return $this->passwordPolicy;
    }

    /**
     * @param PasswordPolicy $passwordPolicy
     * @return PasswordPolicyValidations
     */
    public function setPasswordPolicy(PasswordPolicy $passwordPolicy)
    {
        $this->passwordPolicy = $passwordPolicy;
        return $this;
    }

    public function removePasswordPolicy()
    {
        $this->passwordPolicy = null;
    }
}
