<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use Throwable;

/**
 * Interface HandlerInterface
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\ErrorHandler
 */
interface ErrorHandlerInterface
{
    /**
     * @return int
     */
    public function getHttpStatusCode();

    /**
     * @return boolean
     */
    public function hasErrors();

    /**
     * @return ErrorsInterface
     */
    public function getErrors();

    /**
     * @param int $code
     * @param string $errorCode
     * @param string $errorRef
     * @param string $shortMessage
     * @param string $longMessage
     * @param Throwable|null $exception
     */
    public function addError($code, $errorCode, $errorRef, $shortMessage, $longMessage, Throwable $exception = null);

    /**
     * @param string $format xml|json
     * @return string
     */
    public function buildResponse($format);

    /**
     * @return Response\ResponseInterface
     */
    public function getResponseObject();

    /**
     * @param array $errors
     */
    public function addErrors(array $errors);
}
