<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\ErrorStorage;

use Doctrine\Common\Collections\ArrayCollection;
use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;

/**
 * Class User
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\ErrorStorage
 */
final class Errors
{
    /**
     * @var integer
     */
    private $code;

    /**
     * @var string
     */
    private $status;

    /**
     * @var string
     */
    private $controller = 'NotFound';

    /**
     * @var string
     */
    private $action = 'NotFound';

    /**
     * @var
     */
    private $trackId;

    /**
     * @var Error[]
     */
    private $error;

    /**
     * @var integer
     */
    private $count;

    /**
     * Errors constructor.
     */
    public function __construct()
    {
        $this->error = new ArrayCollection();
        $this->count = 0;
        $this->trackId = ApiException::getTrackId();
    }

    /**
     * @param Error $error
     */
    public function addError(Error $error)
    {
        // set a outer code later maybe check the code level
        $this->code = $error->getCode();
        $this->status = $error->getStatus();

        if (!$this->error->contains($error)) {
            $this->error->add($error);
            $this->count++;
        }
    }

    /**
     *
     * @param Error $error
     */
    public function removeError(Error $error)
    {
        $this->error->removeElement($error);
        $this->count--;
    }

    /**
     *
     * @return boolean
     */
    public function hasErrors()
    {
        return 0 < $this->count;
    }

    /**
     * @return integer
     */
    public function getErrorsCount()
    {
        return $this->count;
    }

    /**
     * @return Error[]|ArrayCollection
     */
    public function getErrors(){
        return $this->error;
    }

    /**
     * @return mixed
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * @param string $controller
     * @return Errors
     */
    public function setController($controller)
    {
        $this->controller = $controller;

        return $this;
    }

    /**
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * @param string $action
     * @return Errors
     */
    public function setAction($action)
    {
        $this->action = $action;

        return $this;
    }
}
