<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version1\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UnknownAction
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response\Version1\Response
 */
class UnknownController
{

    /**
     * @Serializer\Exclude()
     * @var string
     */
    private $name;

    /**
     * @Serializer\Type("array<Sso\WebserviceBundle\ErrorHandler\Response\Version1\Response\UnknownAction>")
     * @Serializer\XmlList(inline=true)
     * @Serializer\XmlKeyValuePairs()
     * @var UnknownAction
     */
    private $actions = [];

    /**
     * UnknownController constructor.
     * @param string $name
     */
    public function __construct($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param UnknownAction $unknownAction
     * @return UnknownController
     */
    public function addUnknownAction(UnknownAction $unknownAction){
        $this->actions[$unknownAction->getName()] = $unknownAction;
        return $this;
    }
}
