<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version2;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorInterface;
use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Error
 *
 * @Serializer\XmlRoot("Errors")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Security\Model\ErrorResponse\Error
 */
class Errors implements ErrorsInterface
{

    /**
     * @Serializer\Exclude()
     * @var string
     */
    private $code;

    /**
     * @Serializer\Exclude()
     * @var string
     */
    private $status;

    /**
     * @Serializer\Exclude()
     * @var string
     */
    private $controller;

    /**
     * @Serializer\Exclude()
     * @var string
     */
    private $action;

    /**
     * @Serializer\Exclude()
     * @var integer
     */
    private $errorCount;

    /**
     * @Serializer\SerializedName("Errors")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\ErrorHandler\Response\Version2\Error>")
     * @Serializer\XmlList(entry="Error")
     * @var ErrorInterface[]
     */
    private $error;

    /**
     * Errors constructor.
     */
    public function __construct()
    {
        $this->error = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return Errors
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Errors
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return ErrorsInterface[]
     */
    public function getErrors(){
        return $this->error;
    }

    /**
     * @param ErrorInterface $error
     * @return $this
     */
    public function addError(ErrorInterface $error){
        if (!$this->error->contains($error)) {
            $this->error->add($error);
        }
        return $this;
    }

    /**
     * @param mixed $errorCount
     * @return Errors
     */
    public function setErrorCount($errorCount)
    {
        $this->errorCount = $errorCount;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getErrorCount()
    {
        return $this->errorCount;
    }

    /**
     * @return mixed
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * @param mixed $controller
     * @return Errors
     */
    public function setController($controller)
    {
        $this->controller = $controller;

        return $this;
    }


    /**
     * @return mixed
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * @param mixed $action
     * @return Errors
     */
    public function setAction($action)
    {
        $this->action = $action;

        return $this;
    }
}