<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version4;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorInterface;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Error
 *
 * @Serializer\XmlRoot("Error")
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\ErrorHandler\Response\Version4
 */
class Error implements ErrorInterface
{
    /**
     * Serializer Mapping
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $code;

    /**
     * Serializer Mapping
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * Serializer Mapping
     * @Serializer\SerializedName("ErrorCode")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $errorCode;

    /**
     * Serializer Mapping
     * @Serializer\SerializedName("ErrorReference")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $errorReference;

    /**
     *
     * Serializer Mapping
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ShortMessage")
     *
     * @var string
     */
    private $shortMessage;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LongMessage")
     */
    private $longMessage;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("Type")
     */
    private $type;

    /**
     * @return integer
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     * @return Error
     */
    public function setCode($code)
    {
        $this->code = (int)$code;

        return $this;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Error
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return string
     */
    public function getShortMessage()
    {
        return $this->shortMessage;
    }

    /**
     * @param string $shortMessage
     * @return Error
     */
    public function setShortMessage($shortMessage)
    {
        $this->shortMessage = $shortMessage;

        return $this;
    }

    /**
     * @return string
     */
    public function getLongMessage()
    {
        return $this->longMessage;
    }

    /**
     * @param string $longMessage
     * @return Error
     */
    public function setLongMessage($longMessage)
    {
        $this->longMessage = $longMessage;

        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return Error
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     * @param string $errorCode
     * @return Error
     */
    public function setErrorCode($errorCode)
    {
        $this->errorCode = $errorCode;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getErrorReference()
    {
        return $this->errorReference;
    }

    /**
     * @param mixed $errorReference
     * @return Error
     */
    public function setErrorReference($errorReference)
    {
        $this->errorReference = $errorReference;

        return $this;
    }
}
