<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\ErrorHandler\Response\Version5;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use Sso\WebserviceBundle\ErrorHandler\Response\FactoryInterface;
use Sso\WebserviceBundle\ErrorHandler\Manager as ErrorManager;
use Sso\WebserviceBundle\ErrorHandler\Response\ResponseInterface;

/**
 * Class Factory
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\User\Show\Response\Version5
 */
final class Factory implements FactoryInterface
{
    /**
     * @var ErrorManager
     */
    private $errorManager;

    /**
     * Factory constructor.
     * @param ErrorManager $errorManager
     */
    public function __construct(ErrorManager $errorManager)
    {
        $this->errorManager = $errorManager;
    }

    /**
     * @return ErrorsInterface
     */
    public function getErrors()
    {
        return $this->errorsBuilder()->buildErrors();
    }

    /**
     * @return ResponseInterface
     */
    public function getErrorResponse(){
        $responseBuilder = new Response\ResponseBuilder($this->getErrors(), $this->errorManager);
        return $responseBuilder->buildErrorResponse();
    }

    /**
     * @return ErrorsBuilder
     */
    private function errorsBuilder(){
        return new ErrorsBuilder($this->errorManager);
    }
}
