<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Event;

use Sso\WebserviceBundle\Entity\Webservice\Type\User;
use Sso\WebserviceBundle\Services\UserGroup\UserGroupDataInterface;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\RequestData\UserSearchInterface as RequestDataInterface;

/**
 * Class Factory
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Event
 */
class Factory
{
    /**
     * @param RequestDataInterface $requestData
     * @return UserAdvancedSearchQueryEvent
     */
    public function userAdvancedSearchQueryEvent(RequestDataInterface $requestData): UserAdvancedSearchQueryEvent
    {
        return new UserAdvancedSearchQueryEvent($requestData);
    }

    /**
     * @param UserGroupDataInterface[] $userGroupData
     * @return UserGroupResponseEvent
     */
    public function userGroupResponseEvent(array $userGroupData): UserGroupResponseEvent
    {
        return new UserGroupResponseEvent($userGroupData);
    }

    /**
     * @param User $user
     * @return UserAuthorizationEvent
     */
    public function userAuthorizationEvent(User $user): UserAuthorizationEvent
    {
        return new UserAuthorizationEvent($user);
    }
}
