<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Event;

use Sso\WebserviceBundle\Services\UserSearch\Advanced\RequestData\UserSearchInterface as RequestDataInterface;
use Symfony\Component\EventDispatcher\Event;

/**
 * Class UserAdvancedSearchQueryEvent
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Event
 */
final class UserAdvancedSearchQueryEvent extends Event
{
    const PRE_BUILD_CONDITIONS = 'ws.user_advanced_search.pre_build_conditions';

    /**
     * @var RequestDataInterface
     */
    private $requestData;

    /**
     * @var string
     */
    private $alias;

    /**
     * @var string
     */
    private $select;

    /**
     * @var string
     */
    private $from;

    /**
     * @var string
     */
    private $join;

    /**
     * @var string
     */
    private $where;

    /**
     * @var string|null
     */
    private $limit;

    /**
     * @var string|null
     */
    private $orderBy;

    /**
     * @var string
     */
    private $groupBy;

    /**
     * @var string|null
     */
    private $sql;

    /**
     * UserAdvancedSearchQueryEvent constructor.
     * @param RequestDataInterface $requestData
     */
    public function __construct(RequestDataInterface $requestData)
    {
        $this->requestData = $requestData;
    }

    /**
     * @return RequestDataInterface
     */
    public function getRequestData(): RequestDataInterface
    {
        return $this->requestData;
    }

    /**
     * @return string
     */
    public function getAlias(): string
    {
        return $this->alias;
    }

    /**
     * @param string $alias
     */
    public function setAlias(string $alias): void
    {
        $this->alias = $alias;
    }

    /**
     * @return string
     */
    public function getSelect(): string
    {
        return $this->select;
    }

    /**
     * @param string $select
     */
    public function setSelect(string $select): void
    {
        $this->select = $select;
    }

    /**
     * @return string
     */
    public function getFrom(): string
    {
        return $this->from;
    }

    /**
     * @param string $from
     */
    public function setFrom(string $from): void
    {
        $this->from = $from;
    }

    /**
     * @return string
     */
    public function getJoin(): string
    {
        return $this->join;
    }

    /**
     * @param string $join
     */
    public function setJoin(string $join): void
    {
        $this->join = $join;
    }

    /**
     * @return string
     */
    public function getWhere(): string
    {
        return $this->where;
    }

    /**
     * @param string $where
     */
    public function setWhere(string $where): void
    {
        $this->where = $where;
    }

    /**
     * @return string|null
     */
    public function getLimit(): ?string
    {
        return $this->limit;
    }

    /**
     * @param string|null $limit
     */
    public function setLimit(?string $limit): void
    {
        $this->limit = $limit;
    }

    /**
     * @return string|null
     */
    public function getOrderBy(): ?string
    {
        return $this->orderBy;
    }

    /**
     * @param string|null $orderBy
     */
    public function setOrderBy(?string $orderBy): void
    {
        $this->orderBy = $orderBy;
    }

    /**
     * @return string
     */
    public function getGroupBy(): string
    {
        return $this->groupBy;
    }

    /**
     * @param string $groupBy
     */
    public function setGroupBy(string $groupBy): void
    {
        $this->groupBy = $groupBy;
    }

    /**
     * @return string|null
     */
    public function buildSql(): ?string
    {
        return implode(' ', [
            $this->select,
            $this->from,
            $this->join,
            $this->where,
            $this->groupBy,
            $this->orderBy,
            $this->limit,
        ]);
    }

    /**
     * @return string|null
     */
    public function getSql(): ?string
    {
        return $this->sql;
    }

    /**
     * @param string|null $sql
     */
    public function setSql(?string $sql): void
    {
        $this->sql = $sql;
    }
}
