<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Event;

use Sso\WebserviceBundle\Services\UserGroup\UserGroupDataInterface;
use Symfony\Component\EventDispatcher\Event;

/**
 * Class UserGroupResponseEvent
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Event
 */
class UserGroupResponseEvent extends Event
{
    const RESPONSE_EVENT = 'ws.user_group.response_event';

    /**
     * @var UserGroupDataInterface[]
     */
    private $userGroupData = [];

    /**
     * UserGroupResponseEvent constructor.
     * @param UserGroupDataInterface[] $userGroupData
     */
    public function __construct(array $userGroupData)
    {
        $this->userGroupData = $userGroupData;
    }

    /**
     * @return UserGroupDataInterface[]
     */
    public function getUserGroupData(): array
    {
        return $this->userGroupData;
    }
}
