<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Generator\ApplicationAttribute;

/**
 * Class Uuid
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Generator\ApplicationAttribute
 */
class UuidGenerator implements GeneratorInterface
{
    /**
     * @return string
     */
    public function getName(): string
    {
        return 'uuid';
    }

    /**
     * @return string
     */
    public function generate(): string
    {
        return \Ramsey\Uuid\Uuid::uuid4()->toString();
    }
}
