<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\ApplicationAttribute;

use Sso\WebserviceBundle\Model\Request\Base as RequestBase;
use Sso\WebserviceBundle\Entity\Webservice\Type\Attribute as ModelAttribute;
use Sso\WebserviceBundle\Entity\Webservice\Type\Application as ModelApplication;

/**
 * Class Base
 * @package Sso\WebserviceBundle\Model\Request\ApplicationAttribute
 */
abstract class Base extends RequestBase
{
    /**
     * @var ModelAttribute
     */
    protected $attributeModel;

    /**
     * @var ModelApplication
     */
    protected $applicationModel;

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        if ($this->applicationModel) {
            $errors = array_merge($errors, $this->applicationModel->errors()->getErrors());
        }
        if ($this->attributeModel) {
            $errors = array_merge($errors, $this->attributeModel->errors()->getErrors());
        }
        return $errors;
    }

    /**
     * @param ModelAttribute $attributeModel
     */
    public function setAttributeModel(ModelAttribute $attributeModel)
    {
        $this->attributeModel = $attributeModel;
    }

    /**
     * @return ModelAttribute
     */
    public function getAttributeModel()
    {
        return $this->attributeModel;
    }

    /**
     * @param ModelApplication $applicationModel
     */
    public function setApplicationModel(ModelApplication $applicationModel)
    {
        $this->applicationModel = $applicationModel;
    }

    /**
     * @return ModelApplication
     */
    public function getApplicationModel()
    {
        return $this->applicationModel;
    }
}
