<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\ApplicationAttribute;

use Sso\WebserviceBundle\Model\Type\Factory as TypeFactory;
use Sso\WebserviceBundle\Api\Manager as ApiManager;
use Sso\WebserviceBundle\Api\Exception\Type\Base as BaseException;
use Sso\WebserviceBundle\Model\Request\ApplicationAttribute;

/**
 * Class Factory
 * @package Sso\WebserviceBundle\Model\Request\ApplicationAttribute
 */
class Factory
{
    /**
     * Type factory
     * @var TypeFactory
     */
    protected $typeF;

    /**
     * Api Manager
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
        $this->typeF = new TypeFactory($this->apiM);
    }

    /**
     * Get request-attribute-show-model
     * @return ApplicationAttribute\Show
     */
    public function show($simpleXML)
    {
        $model = new ApplicationAttribute\Show($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Get request-attribute-add-model
     * @return ApplicationAttribute\Add
     */
    public function add($simpleXML)
    {
        $model = new ApplicationAttribute\Add($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }
        return $model;
    }

    /**
     * Get request-attribute-delete-model
     * @return ApplicationAttribute\Delete
     */
    public function delete($simpleXML)
    {
        $model = new ApplicationAttribute\Delete($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }
        return $model;
    }
}
