<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\ApplicationAttribute;

/**
 * Class Show
 * @package Sso\WebserviceBundle\Model\Request\ApplicationAttribute
 */
class Show extends Base
{
    /**
     * Init attribute model
     * @param \SimpleXMLElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setApplicationModel($this->_factoryApplication($simpleXML->Key->ApplicationType->children()));
        $this->setAttributeModel($this->_factoryAttribute($simpleXML->Key->AttributeType->children()));
    }

    /**
     * Build attribute object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\Attribute
     */
    protected function _factoryAttribute($xml)
    {
        // Validate for add
        return $this->typeF->attribute($xml, array('ApplicationAttribute_Show'));
    }

    /**
     * Build application object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\Application
     */
    protected function _factoryApplication($xml)
    {
        // Validate for adding new attribute
        return $this->typeF->application($xml, array('ApplicationAttribute_Show'));
    }

    /**
     * Returns a list of allowed field names in xml
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
                . '<ApplicationType required="true">'
                . '<Name required="true"></Name>'
                . '</ApplicationType>'
                . '<AttributeType required="true">'
                . '<Name required="true"></Name>'
                . '</AttributeType>'
                . '</Key>';
    }
}
