<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\ApplicationRole;

use Sso\WebserviceBundle\Model\Request\Base as RequestBase;
use Sso\WebserviceBundle\Entity\Webservice\Type\Application as ModelApplication;
use Sso\WebserviceBundle\Entity\Webservice\Type\Role as ModelRole;

/**
 * Class Base
 * @package Sso\WebserviceBundle\Model\Request\ApplicationRole
 */
abstract class Base extends RequestBase
{
    /**
     * @var ModelRole
     */
    protected $roleModel;

    /**
     * @var ModelApplication
     */
    protected $applicationModel;

    /**
     * Build role object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\Role
     */
    abstract protected function _factoryRole($xml);

    /**
     * Build application object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\Application
     */
    abstract protected function _factoryApplication($xml);

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        if ($this->applicationModel) {
            $errors = array_merge($errors, $this->applicationModel->errors()->getErrors());
        }
        if ($this->roleModel) {
            $errors = array_merge($errors, $this->roleModel->errors()->getErrors());
        }
        return $errors;
    }

    /**
     * @param ModelRole $roleModel
     */
    public function setRoleModel(ModelRole $roleModel)
    {
        $this->roleModel = $roleModel;
    }

    /**
     * @return ModelRole
     */
    public function getRoleModel()
    {
        return $this->roleModel;
    }

    /**
     * @param ModelApplication $applicationModel
     */
    public function setApplicationModel(ModelApplication $applicationModel)
    {
        $this->applicationModel = $applicationModel;
    }

    /**
     * @return ModelApplication
     */
    public function getApplicationModel()
    {
        return $this->applicationModel;
    }
}
