<?php

/**
 * Respnose factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request;

use Sso\WebserviceBundle\Api\Manager as ApiManager;

/**
 * Request factory class
 */
class Factory
{

    /**
     * List of factories
     * @var array
     */
    protected $factories;

    /**
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Request\Application\Factory
     */
    public function application()
    {
        return $this->getFactory('Sso\WebserviceBundle\Model\Request\Application\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Request\ApplicationAttribute\Factory
     */
    public function applicationAttribute()
    {
        return $this->getFactory('Sso\WebserviceBundle\Model\Request\ApplicationAttribute\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Request\ApplicationRole\Factory
     */
    public function applicationRole()
    {
        return $this->getFactory('Sso\WebserviceBundle\Model\Request\ApplicationRole\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Request\User\Factory
     */
    public function user()
    {
        return $this->getFactory('Sso\WebserviceBundle\Model\Request\User\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Request\UserApplication\Factory
     */
    public function userApplication()
    {
        return $this->getFactory('Sso\WebserviceBundle\Model\Request\UserApplication\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Request\UserApplicationAttribute\Factory
     */
    public function userApplicationAttribute()
    {
        return $this->getFactory('Sso\WebserviceBundle\Model\Request\UserApplicationAttribute\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Request\UserApplicationRole\Factory
     */
    public function userApplicationRole()
    {
        return $this->getFactory('Sso\WebserviceBundle\Model\Request\UserApplicationRole\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Request\UserService\Factory
     */
    public function userService()
    {
        return $this->getFactory('Sso\WebserviceBundle\Model\Request\UserService\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Request\UserSearch\Factory
     */
    public function userSearch()
    {
        return $this->getFactory('Sso\WebserviceBundle\Model\Request\UserSearch\Factory');
    }

    /**
     * Get factory object
     * @param string $class
     * @return object
     */
    protected function getFactory($class)
    {
        return isset($this->factories[$class]) ? $this->factories[$class] : ($this->factories[$class] = new $class($this->apiM));
    }
}
